#include <p30fxxxx.h>
#include <spi.h>

/********************************************************************
*     Function Name :  CloseSPI1                                    *
*     Description   :  This routine disables the SPI module and its *
*                      interrupt bits.                              *
*     Parameters    :  None                                         *
*     Return Value  :  None                                         *
********************************************************************/

void CloseSPI1()
{ 
  
      IEC0bits.SPI1IE = 0;  /* Disable the Interrupt bit in the 
                               Interrupt Enable Control Register */
      SPI1STATbits.SPIEN = 0;
                            /*  Disable the module. All pins controlled
                                by PORT Functions */
      IFS0bits.SPI1IF = 0;  /* Disable the Interrupt flag bit in the
                               Interrupt Flag Control Register */    
}
